﻿using Curse.Friends.BugsWebService.Configuration;
using Curse.Friends.BugsWebService.Contracts;
using Curse.Logging;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using Curse.Extensions;

namespace Curse.Friends.BugsWebService
{
    public static class MongooseHelper
    {
        private static readonly string submitRoute = "submit";
        private static readonly LogCategory ThrottledLogger = new LogCategory("MongooseHelper") { Throttle = TimeSpan.FromMinutes(20), ReleaseLevel = LogLevel.Trace };
        private static HttpClient _client;
   
        static MongooseHelper()
        {
            _client = new HttpClient();
            _client.BaseAddress = new Uri(BugsWebServiceConfiguration.Current.MongooseBaseUrl);                
        }

        public static bool SubmitReport(BugReport report, ReportingUserInfo reportingUser)
        {    
            var mongooseBugReport = new
            {                
                applicationLocation = report.ApplicationLocation,
                applicationName = "TwitchDesktop",
                attachments = report.Attachments,
                callQuality = report.CallQuality,
                dateCreated = DateTime.UtcNow.ToEpochMilliseconds(),
                dateLastReported = DateTime.UtcNow.ToEpochMilliseconds(),
                exceptionDetails = report.ExceptionDetails,
                gameConfiguration = report.GameConfiguration,
                incompatibleProcesses = JsonConvert.SerializeObject(report.IncompatibleProcesses),
                lastAttemptedVoiceHostID = report.LastAttemptedVoiceHostID,
                logData = report.LogData,
                message = report.Message,
                overlayExitCode = report.OverlayExitCode,
                overlayGameState = GetGameState(report.OverlayGameState ?? 0),
                platform = report.Platform.ToString(),
                priority = "Medium",
                reportType = report.Type.ToString(),
                runningProcesses = JsonConvert.SerializeObject(report.RunningProcesses),
                stackTraceHash = report.StackTraceHash,
                submissionType = (report.Type == BugReportType.BugOrDefect || report.Type == BugReportType.FeatureSuggestion || report.Type == BugReportType.PostiveFeedback || report.Type == BugReportType.NegativeFeedback) ? "Manual" : "Automatic",
                systemInformation = report.SystemInformation,
                timeConfiguration = report.TimeConfiguration,
                title = report.Title,                     
                userSettings = report.UserSettings,
                version = report?.ClientVersion,                
                curseUserID = reportingUser.CurseUserID.ToString(),
                twitchUserID = reportingUser.TwitchUserID,
                username = reportingUser.Username,
                email = reportingUser.Email                
            };

            var mongooseBugReportSerialized = JsonConvert.SerializeObject(mongooseBugReport);
            ThrottledLogger.Trace("Sending Bug Report to Mongoose");
            var response = _client.PostAsync(submitRoute, new StringContent(mongooseBugReportSerialized, System.Text.Encoding.UTF8, "application/json")).Result;
            if (!response.IsSuccessStatusCode)
            {
                string errorContent = null;
                try
                {
                    errorContent = response.Content.ReadAsStringAsync().Result;
                }
                catch { }
                ThrottledLogger.Error("Unsuccessful response from mongoose", new
                {
                    statuscode = response.StatusCode,
                    content = errorContent
                });                
                return false;
            }
            return true;     
        }

        private static string GetGameState(byte gameState)
        {
            switch (gameState)
            {
                case 1:
                    return "Launcher";
                case 2:
                    return "Loading";
                case 3:
                    return "Login";
                case 4:
                    return "InGame";
                case 5:
                    return "EndOfGame";
                default:
                    return "None";
            }
        }
    }
}