﻿using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.MicroService;
using System;

namespace Curse.Friends.CallsWebService.Contracts
{
    public class AdHocCallRequest : BaseRequestContract
    {

        public int? GameID { get; set; }
        public string UserDisplayName { get; set; }
        public string ClientVersion { get; set; }
        
        protected override bool DoValidate()
        {
            if (!UserDisplayName.SafeRange(0, Friendship.OtherUserNicknameMaxLength))
            {
                _validationMessage = "If specified, UserDisplayName must be less than " + Friendship.OtherUserNicknameMaxLength + " characters.";
                return false;
            }

            Version throwaway;
            if (ClientVersion == null || !Version.TryParse(ClientVersion, out throwaway))
            {
                _validationMessage = "ClientVersion is invalid.";
                return false;
            }

            return true;
        }
    }
}