﻿using System;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.CallsWebService.Contracts
{
    public class AutoMatchCallRequest : BaseRequestContract
    {
        public int GameID { get; set; }
        public string UserDisplayName { get; set; }
        public string ClientVersion { get; set; }
        public long AutoMatchKey { get; set; }

        protected override bool DoValidate()
        {
            if (!UserDisplayName.SafeRange(1, Friendship.OtherUserNicknameMaxLength))
            {
                _validationMessage = "If specified, UserDisplayName must be  between 1 and " + Friendship.OtherUserNicknameMaxLength + " characters.";
                return false;
            }

            Version throwaway;
            if (ClientVersion == null || !Version.TryParse(ClientVersion, out throwaway))
            {
                _validationMessage = "ClientVersion is invalid.";
                return false;
            }

            return true;
        }
    }
}