﻿using System;
using Curse.Friends.MicroService;
using Curse.Friends.Enums;

namespace Curse.Friends.CallsWebService.Contracts
{
    public class ConversationCallRequest : BaseRequestContract
    {        
        public string ClientVersion { get; set; }
        public bool Force { get; set; }
        public bool SendInvitation { get; set; }
        public CallMode Mode { get; set; }

        protected override bool DoValidate()
        {                     
            Version throwaway;
            if (ClientVersion == null || !Version.TryParse(ClientVersion, out throwaway))
            {
                _validationMessage = "ClientVersion is invalid.";
                return false;
            }

            if (Mode == 0)
            {
                Mode = CallMode.Audio;                
            }

            return true;
        }
    }
}