﻿using Curse.Friends.Configuration.CurseVoiceService;
using System;
using System.Linq;

namespace Curse.Friends.CallsWebService.Contracts
{
    public class HandshakeAutoMatchResponse
    {
        public bool HasMatches { get; set; }
        public int PlayerCount { get; set; }
        public HandshakeUserContract[] Users { get; set; }
        public string ExistingInviteCode { get; set; }
        public string ExistingInstanceCode { get; set; }

        public static HandshakeAutoMatchResponse FromServiceContract(AutoMatchHandshakeResponse response)
        {
            return new HandshakeAutoMatchResponse
            {
                ExistingInstanceCode = response.ExistingInstanceCode,
                ExistingInviteCode = response.ExistingInviteCode,
                HasMatches = response.HasMatches,
                PlayerCount = response.PlayerCount,
                Users = response.Users == null ? new HandshakeUserContract[0] : response.Users.Select(HandshakeUserContract.FromServiceContract).ToArray()
            };
        }
    }

    public class HandshakeUserContract
    {
        public int UserID { get; set; }
        public string DisplayName { get; set; }
        public DateTime Timestamp { get; set; }
        public bool Declined { get; set; }
        public bool IsRecent { get; set; }

        public static HandshakeUserContract FromServiceContract(VoiceHandshakeUser user)
        {
            return new HandshakeUserContract
            {
                Declined = user.Declined,
                DisplayName = user.DisplayName,
                IsRecent = user.IsRecent,
                Timestamp = user.Timestamp,
                UserID = user.UserID,
            };
        }
    }
}