﻿
using Curse.Friends.Configuration.CurseVoiceService;
using System;

namespace Curse.Friends.CallsWebService.Contracts
{
    public class ReportGameSessionsRequest
    {
        public GameSessionMetricsContract[] GameSessionMetrics { get; set; }
    }

    public class GameSessionMetricsContract
    {
        public int GameID { get; set; }

        public bool Successful { get; set; }

        public int ExitCode { get; set; }

        public string GameStateName { get; set; }

        public byte GameState { get; set; }

        public static GameSessionMetric ToServiceContract(GameSessionMetricsContract arg)
        {
            return new GameSessionMetric
            {
                GameID = arg.GameID,
                ExitCode = arg.ExitCode,
                GameState = arg.GameState,
                GameStateName = arg.GameStateName,
                Successful = arg.Successful,
            };
        }
    }
}