﻿using System;
using Curse.Extensions;
using Curse.Friends.MicroService;
using Curse.Logging;

namespace Curse.Friends.CallsWebService.Contracts
{
    public enum VoiceHostCallbackType
    {
        CallStarted,
        CallEnded,
        UsersJoined,
        UsersLeft
    }

    public class VoiceHostCallbackRequest : BaseRequestContract
    {
        public Guid GroupID { get; set; }
        public int[] UserIDs { get; set; }
        public VoiceHostCallbackType ChangeType { get; set; }
        public string InviteCode { get; set; }

        protected override bool DoValidate()
        {
            if (!InviteCode.SafeRange(4, 10))
            {
                Logger.Warn("Voice host callback included an invalid invite code.", this);
                _validationMessage = "Invalid invite code";
                return false;
            }

            if (GroupID == Guid.Empty)
            {
                Logger.Warn("Voice host callback included an invalid group ID.", this);
                _validationMessage = "Invalid invite code";
                return false;
            }

            return true;
        }
    }
}