﻿using Curse.CloudSearch;
using Nest;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.ChatHistoryTests.Models
{
    [ElasticType(Name = "conversationMessage", IdProperty = "id")]
    public class ConversationMessage
    {
        /// A unique GUID formatted string to uniquely identify this message        
        [ElasticProperty(Name = "id", Type = FieldType.String, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public string ID
        {
            get;
            set;
        }

        /// A unique GUID formatted string to uniquely identify this message
        [ElasticProperty(Name = "conversationId", Type = FieldType.String, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public string ConversationID
        {
            get;
            set;
        }

        /// <summary>
        /// The epoch formatted timestamp, in millisconds.
        /// </summary>
        [ElasticProperty(Name = "timestamp", Type = FieldType.Long, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public long Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// The user ID of the sender
        /// </summary>        
        [ElasticProperty(Name = "senderId", Type = FieldType.Integer, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int SenderID { get; set; }

        /// <summary>
        /// The username of the sender (in case the key gets orphaned on the client side)
        /// </summary>
        [ElasticProperty(Name = "senderName", Type = FieldType.String, Store = true, Index = FieldIndexOption.No)]
        public string SenderName { get; set; }

        /// <summary>
        /// The effective permissions of the sender  (at the time of the post)
        /// </summary>
        [ElasticProperty(Name = "senderPermissions", Type = FieldType.Long, Store = true, Index = FieldIndexOption.No)]
        public long SenderPermissions { get; set; }

        /// <summary>
        /// The roles of the sender (at the time of the post)
        /// </summary>
        [ElasticProperty(Name = "senderRoles", Store = true, Index = FieldIndexOption.No)]
        public int[] SenderRoles { get; set; }

        /// <summary>
        /// The userIDs of anyone mentioned in this message
        /// </summary>
        [ElasticProperty(Name = "mentions", Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int[] Mentions { get; set; }

        /// <summary>
        /// The user ID of the recipient (this can be 0, depending on the conversation type)
        /// </summary>
        [ElasticProperty(Name = "recipientId", Type = FieldType.Integer, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int RecipientID { get; set; }

        /// <summary>
        ///  The body of the message (serialized to JSON)
        /// </summary>
        [ElasticProperty(Name = "body", Type = FieldType.String, Store = true, Index = FieldIndexOption.Analyzed)]
        public string Body { get; set; }

        /// <summary>
        /// Whether or not the message is deleted
        /// </summary>
        [ElasticProperty(Name = "isDeleted", Type = FieldType.Boolean, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int IsDeleted { get; set; }

        /// <summary>
        /// The date the message was deleted
        /// </summary>
        [ElasticProperty(Name = "deletedTimestamp", Type = FieldType.Long, Store = true, Index = FieldIndexOption.No)]
        public long DeletedTimestamp { get; set; }

        /// <summary>
        /// The user ID of the person that deleted the message
        /// </summary>
        [ElasticProperty(Name = "deletedUserId", Type = FieldType.Integer, Store = true, Index = FieldIndexOption.No)]
        public int DeletedUserID { get; set; }

        /// <summary>
        /// The user ID of the person that edited the message
        /// </summary>
        [ElasticProperty(Name = "editedUserId", Type = FieldType.Integer, Store = true, Index = FieldIndexOption.No)]
        public int EditedUserID { get; set; }
        
        /// <summary>
        /// The date the message was edit
        /// </summary>
        [ElasticProperty(Name = "editedTimestamp", Type = FieldType.Long, Store = true, Index = FieldIndexOption.No)]
        public long EditedTimestamp { get; set; }

        /// <summary>
        /// The number of likes the mssage has
        /// </summary>
        [ElasticProperty(Name = "likeCount", Type = FieldType.Integer, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int LikeCount { get; set; }

        /// <summary>
        /// The IDs of all users that have liked this message
        /// </summary>
        [ElasticProperty(Name = "likeUserIds", Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int[] LikeUserIDs { get; set; }

        
        ///// <summary>
        ///// The names of all users that have liked this message
        ///// </summary>
        [ElasticProperty(Name = "likeUsernames", Store = true, Index = FieldIndexOption.No)]
        public string[] LikeUsernames { get; set; }

        /// <summary>
        /// The content type tags associates with this message
        /// </summary>
        [ElasticProperty(Name = "contentTags", Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int[] ContentTags { get; set; }


        /// <summary>
        /// The content type tags associates with this message
        /// </summary>
        [ElasticProperty(Name = "attachments", Type = FieldType.Object, Store = true, Index = FieldIndexOption.No)]
        public ConversationAttachment[] Attachments
        {
            get;
            set;
        }


    }
}
