﻿using Nest;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.ChatHistoryTests.Models
{

    [ElasticType(Name = "conversationNotification")]
    public class ConversationNotification
    {
        /// A unique GUID formatted string to uniquely identify this message
        [ElasticProperty(Name = "conversationId", Type = FieldType.String, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public string ConversationID
        {
            get;
            set;
        }

        /// <summary>
        /// The epoch formatted timestamp, in millisconds.
        /// </summary>
        [ElasticProperty(Name = "timestamp", Type = FieldType.Long, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public long Timestamp
        {
            get;
            set;
        }
    }
}
