﻿using System;
using System.ServiceModel;
using System.ServiceModel.Channels;

namespace Curse.Friends.Configuration
{
    public static class BindingHelper
    {
        public static Binding GetBasicBinding(bool useSsl, int sendTimeoutSeconds = 10)
        {
            return useSsl ? (Binding)GetBasicHttpsBinding(sendTimeoutSeconds) : GetBasicHttpBinding(sendTimeoutSeconds);
        }

        public static BasicHttpBinding GetBasicHttpBinding(int sendTimeoutSeconds = 10)
        {
            var binding = new BasicHttpBinding()
            {
                OpenTimeout = TimeSpan.FromSeconds(5),
                SendTimeout = TimeSpan.FromSeconds(sendTimeoutSeconds),
                ReceiveTimeout = TimeSpan.FromSeconds(10),

            };

            return binding;
        }

        public static BasicHttpsBinding GetBasicHttpsBinding(int sendTimeoutSeconds = 10)
        {
            var binding = new BasicHttpsBinding()
            {
                OpenTimeout = TimeSpan.FromSeconds(5),
                SendTimeout = TimeSpan.FromSeconds(sendTimeoutSeconds),
                ReceiveTimeout = TimeSpan.FromSeconds(10),
            };

            return binding;
        }
    }
}
