﻿using Curse.Logging;
using System;
using System.ServiceModel;

namespace Curse.Friends.Configuration.CurseVoiceService
{
    public partial class CurseVoiceServiceClient : IDisposable
    {
        public void Dispose()
        {
            try
            {
                if (State != CommunicationState.Faulted)
                {
                    Close();
                }
            }
            finally
            {
                if (State != CommunicationState.Closed)
                {
                    try
                    {
                        Abort();
                    }
                    catch
                    {

                    }
                }
            }
        }

        private static CurseVoiceServiceClient GetVoiceServiceClient(int timeoutSeconds = 10)
        {
            return new CurseVoiceServiceClient(BindingHelper.GetBasicBinding(FriendsServiceConfiguration.Instance.CentralServiceUrl.StartsWith("https"), timeoutSeconds),
                new EndpointAddress(FriendsServiceConfiguration.Instance.CentralServiceUrl));
        }

        public static TResponse TryServiceCall<TResponse>(string actionName, Func<CurseVoiceServiceClient, TResponse> action, int timeoutSeconds = 2, int maxAttempts = 3, int attempt = 0)
        {
            attempt++;

            using (var client = GetVoiceServiceClient(timeoutSeconds))
            {

                try
                {
                    return action(client);
                }
                catch (Exception ex) // Only catch communication issues, and retry
                {
                    if (ex is CommunicationException || ex is TimeoutException)
                    {
                        if (attempt <= maxAttempts)
                        {
                            var newTimeout = timeoutSeconds * attempt;
                            Logger.Warn(ex, actionName + " service call failed after a " + timeoutSeconds + " second timeout. It will be retried with a new timeout of " + newTimeout + " seconds", new { timeoutSeconds, maxAttempts, attempt });
                            return TryServiceCall(actionName, action, newTimeout, maxAttempts, attempt);
                        }
                    }
                    else
                    {
                        Logger.Error(ex, actionName + " service failed with a " + ex.GetType().Name + " exception");
                        throw;
                    }
                }
            }

            throw new Exception(actionName + " failed after " + attempt + " attempts");
        }
    }
}
