﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Xml.Serialization;

namespace Curse.Friends.Configuration
{

    [XmlType("QueueConfigurationState")]
    public class QueueConfigurationState
    {
        private static QueueConfigurationState _instance = null;

        public static QueueConfigurationState Instance
        {
            get { return _instance; }
        }


        private static string _configPath = null;

        public static void Initialize(string appIdentity)
        {
            // Try to load the config, based on the compilation mode

            _configPath = FindConfigPath(appIdentity);

            if (!File.Exists(_configPath))
            {
                _instance = new QueueConfigurationState();
                return;
            }

            using (var reader = new StreamReader(_configPath))
            {
                var dcs = new XmlSerializer(typeof(QueueConfigurationState));
                _instance = (QueueConfigurationState)dcs.Deserialize(reader);
            }

        }

        private static string FindConfigPath(string appIdentity)
        {
            string configFolder = Path.Combine(@"C:\Curse\Config\", appIdentity);
            if (!Directory.Exists(configFolder))
            {
                Directory.CreateDirectory(configFolder);
            }
            configFolder = Path.Combine(configFolder, "QueueState.config");
            return configFolder;
        }

        public void Save()
        {
            using (var writer = new StreamWriter(_configPath))
            {
                var dcs = new XmlSerializer(typeof(QueueConfigurationState));
                dcs.Serialize(writer, this);
            }
        }

        [XmlArray("QueueVersions")]
        [XmlArrayItem("QueueVersion")]
        public List<QueueVersion> QueueVersions { get; set; }
    }

    [Serializable]
    [XmlType(TypeName = "QueueVersion")]
    public class QueueVersion
    {
        public QueueVersion() { }

        public QueueVersion(string name, int version)
        {
            Key = name;
            Value = version;
        }

        public string Key
        { get; set; }

        public int Value
        { get; set; }
    }
}
