﻿using Curse.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace Curse.Friends.Configuration
{
    public static class RegionDiscovery
    {
        static readonly Regex AmazonRegionPattern = new Regex(@"(?<PrimaryRegion>us|sa|eu|ap)-(?<SecondaryRegion>(north|south)?(east|west)?)-[0-9]+", RegexOptions.Compiled | RegexOptions.IgnoreCase);
        private static string GetCurrentAmazonRegion()
        {
            string regionInfo = null;

            for (var i = 0; i < 10; i++)
            {
                try
                {
                    using (var client = new WebClient())
                    {                        
                        regionInfo = client.DownloadString("http://169.254.169.254/latest/meta-data/placement/availability-zone");
                    }

                    if(!string.IsNullOrEmpty(regionInfo))
                    {
                        break;
                    }
                }
                catch (Exception ex)
                {
                    Logger.Warn(ex, "Failed to identify the region. Trying again...");
                }               
            }

            var match = AmazonRegionPattern.Match(regionInfo);

            if(!match.Success)
            {
                Logger.Error("Unable to determine region from value: " + regionInfo);
                return null;
            }

            var mainRegion = match.Groups["PrimaryRegion"].Value;
            var secondaryRegion = match.Groups["SecondaryRegion"].Value;

            return mainRegion + "-" + secondaryRegion;
        }

        public static string GetCurrentRegionKey()
        {

#if DEBUG
            return "US-East";
#else
            return GetCurrentAmazonRegion();
#endif
        }
    }
}
