﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.ContactsWebService.Contracts
{
    public class ChangeFriendshipPreferencesRequest : BaseRequestContract
    {
        
        public NotificationPreference Preference { get; set; }

        public HashSet<String> FilterSet { get; set; }

        protected override bool DoValidate()
        {            
            if ((Preference < NotificationPreference.Enabled) || (Preference > NotificationPreference.Filtered))
            {
                _validationMessage = "Invalid preference value";
                return false;
            }
            if (FilterSet != null &&
                (FilterSet.Count > Group.MaxNumberFilterWords || FilterSet.Aggregate(0, (count, fw) => count + fw.Length) > Group.MaxTotalFilterLength))
            {
                _validationMessage = "Too many filter words or the total length of the filter words is too long";
                return false;
            }

            return true;
        }
    }
}