﻿using Curse.Friends.Data;
using Curse.Friends.MicroService;
using Curse.Logging;

namespace Curse.Friends.ContactsWebService.Contracts
{
    public class FriendListMultiSearchRequest : BaseRequestContract
    {
        public FriendListSearchRequest[] FriendLists
        {
            get;
            set;
        }

        protected override bool DoValidate()
        {
            if (FriendLists == null || FriendLists.Length == 0)
            {
                _validationMessage = "Friend list is null or empty.";
                return false;
            }

            if (FriendLists.Length > FriendHint.MaxListsPerUser)
            {
                Logger.Warn("A user attempted to upload " + FriendLists.Length + " friend lists. This is way too many, and the request will be discarded.");
                _validationMessage = "Too many lists in the request";
                return false;
            }

            foreach (var list in FriendLists)
            {
                if (list == null)
                {
                    _validationMessage = "Friend list is null or empty.";
                    return false;
                }

                list.Validate();
            }

            return true;
        }
    }
}