﻿using System.Linq;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;
using Curse.Friends.NotificationContracts;
using Curse.Logging;

namespace Curse.Friends.ContactsWebService.Contracts
{
    public class FriendListSearchRequest : BaseRequestContract
    {
        public FriendHintContract Identity
        {
            get;
            set;
        }

        public FriendHintContract[] FriendsList
        {
            get;
            set;
        }

        protected override bool DoValidate()
        {
            string validationReason;

            if (Identity == null)
            {
                _validationMessage = "Empty or null identity or friends list.";
                return false;
            }

            if (FriendsList == null)
            {
                _validationMessage = "The friends list is null";
                return false;
            }

            if (FriendsList.Length == 0)
            {
                _validationMessage = "The friends list is empty.";
                return false;
            }

            var identity = FriendHint.FromNotification(Identity);

            if (!identity.Validate(out validationReason))
            {
                _validationMessage = "Invalid identity: " + validationReason;
                return false;
            }

            if (Identity.Status == FriendHintStatus.Deleted)
            {                
                return false;
            }
            
            var usableFriends = FriendsList.Count(p => p != null);

            if (usableFriends == 0)
            {
                _validationMessage = "The friends list is empty";
                return false;
            }

            if (usableFriends > 3000)
            {
                _validationMessage = "The friends list must be between 1 and 3000 items long. List count: " + FriendsList.Length;
                Logger.Info("[FriendListSearch] User submitted a friends list that is too large to process", new { Identity, FriendsListLength = FriendsList.Length });
                return false;
            }

            return true;
        }
    }
}