﻿using Curse.Friends.NotificationContracts;

namespace Curse.Friends.ContactsWebService.Contracts
{

    public enum FriendSearchStatus
    {
        Unknown,
        Successful,
        Error,
        Invalid
    }

    public class FriendSearchResponse
    {
        public CharacterSearchContract[] CharacterMatches { get; set; }
        public EmailSearchContract[] EmailMatches { get; set; }
        public UsernameSearchContract[] UserMatches { get; set; }
        public PlatformSearchContract[] PlatformMatches { get; set; }

        public int ElapsedMilliseconds { get; set; }

        public void AddSearchTime(int ms)
        {
            ElapsedMilliseconds += ms;
        }

        public FriendSearchResponse()
        {
            CharacterMatches = new CharacterSearchContract[0];
            EmailMatches = new EmailSearchContract[0];
            UserMatches = new UsernameSearchContract[0];
            PlatformMatches = new PlatformSearchContract[0];
        }

        public FriendSearchStatus Status
        {
            get;
            set;
        }

    }
}