﻿using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.ContactsWebService.Contracts
{
    public class FriendshipRequest : BaseRequestContract
    {
        public string KnownIdentity
        {
            get;
            set;
        }

        public string InvitationMessage
        {
            get;
            set;
        }

        public bool IsFromSuggestion
        {
            get;
            set;
        }

        protected override bool DoValidate()
        {
            if (string.IsNullOrEmpty(KnownIdentity) || KnownIdentity.Length > Friendship.OtherUserNicknameMaxLength)
            {
                _validationMessage = "KnownIdentity must be supplied, and less than " + Friendship.OtherUserNicknameMaxLength + " characters.";
                return false;
            }

            if (!string.IsNullOrEmpty(InvitationMessage) && InvitationMessage.Length > Friendship.InvitationMaxLength)
            {
                _validationMessage = "InvitationMessage must be empty, or less than " + Friendship.InvitationMaxLength + " characters.";                
                return false;
            }
            
            return true;
        }
    }
}