﻿using System.Linq;
using System.Web.Http;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;
using Curse.Friends.NotificationContracts;
using Curse.Friends.Statistics;
using System.Collections.Generic;
using Curse.Extensions;
using Curse.Friends.Data.Models;

namespace Curse.Friends.ContactsWebService.Controllers
{
    [RoutePrefix("friend-suggestions")]
    public class FriendSuggestionsController : MicroServiceController
    {
        /// <summary>
        /// Gets the full list of a user's friend suggestions.
        /// </summary>
        /// <returns></returns>
        [Route("")]
        [HttpGet]
        public FriendSuggestionContract[] GetAll()
        {

            var userAndRegion = GetCurrentUserAndRegion();
            

            var activeSuggestions = FriendSuggestion.GetAllLocal(fs => fs.UserID, userAndRegion.User.UserID)
                                                    .Where(fs => fs.Status == FriendSuggestionStatus.Pending)
                                                    .ToArray();

            return FriendSuggestion.ToValidNotifications(userAndRegion.User.UserID, activeSuggestions);
        }


        /// <summary>
        /// Declines a pending friend sugggestion.
        /// </summary>
        /// <param name="friendID">The id of the suggested friend to decline.</param>
        /// <returns></returns>
        [Route("{friendID}")]
        [HttpDelete]
        public IHttpActionResult Decline(int friendID)
        {
            var userAndRegion = GetCurrentUserAndRegion();
            var suggestion = FriendSuggestion.Get(userAndRegion.Region.RegionID, userAndRegion.User.UserID, friendID);
            if (suggestion == null || suggestion.Status != FriendSuggestionStatus.Pending)
            {
                return NotFound();
            }

            suggestion.Status = FriendSuggestionStatus.Declined;
            suggestion.Update();
            FriendsStatsManager.Current.SuggestionsDeclined.Track();
            return Ok();
        }

    }
}
