﻿using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.ConversationsWebService.Contracts
{

    public class ConversationAttachmentEditRequest : BaseRequestContract
    {
        public string MessageID { get; set; }
        public long MessageTimestamp { get; set; }
        public string Title { get; set; }
        
        protected override bool DoValidate()
        {
           if (string.IsNullOrEmpty(MessageID))
            {
                return false;
            }

            if (MessageTimestamp <= 0)
            {
                return false;
            }

            if (Title.SafeLength() > Attachment.MaxTitleLength)
            {
                return false;
            }

            return true;
        }
    }
}