﻿using System;
using Curse.Extensions;
using Curse.Friends.Data.Messaging;
using Curse.Friends.MicroService;

namespace Curse.Friends.ConversationsWebService.Contracts
{
    public class ConversationCreateMessageRequest : BaseRequestContract
    {
        public string MachineKey
        {
            get; 
            set;
        }      

        public Guid AttachmentID
        {
            get;
            set;
        }

        public Guid ClientID
        {
            get;
            set;
        }

        public string Body
        {
            get;
            set;
        }

        public int AttachmentRegionID
        {
            get;
            set;
        }

        protected override bool DoValidate()
        {
            // Check that the message length is valid
            if (!Body.SafeRange(1, ConversationConstants.MaxMessageLength))
            {
                _validationMessage = "Body is an invalid length.";
                return false;
            }


            if (string.IsNullOrWhiteSpace(MachineKey))
            {
                _validationMessage = "MachineKey is an invalid length";
                return false;
            }

            return true;
        }
    }
}