﻿using Curse.Friends.MicroService;

namespace Curse.Friends.ConversationsWebService.Contracts
{
    public class ConversationDeleteMessageRequest : BaseRequestContract
    {
        public string ConversationID { get; set; }
        public string MessageID { get; set; }
        public long MessageTimestamp { get; set; }
        
        protected override bool DoValidate()
        {
            if (string.IsNullOrEmpty(ConversationID))
            {
                return false;
            }

            if (string.IsNullOrEmpty(MessageID))
            {
                return false;
            }

            if (MessageTimestamp <= 0)
            {
                return false;
            }          

            return true;
        }
    }
}