﻿using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Data.Messaging;
using Curse.Friends.MicroService;

namespace Curse.Friends.ConversationsWebService.Contracts
{
    public class ConversationEditMessageRequest : BaseRequestContract
    {               
        public string Body { get; set; }
        public int[] Mentions { get; set; }

        protected override bool DoValidate()
        {
            if (Body.SafeLength() > ConversationConstants.MaxMessageLength)
            {
                return false;
            }

            if (Mentions != null && Mentions.Length > 20)
            {
                return false;
            }

            return true;
        }
    }
}