﻿using System;
using Curse.Friends.MicroService;

namespace Curse.Friends.ConversationsWebService.Contracts
{
    public class ConversationHistoryRequest : BaseRequestContract
    {
        public int FriendID
        {
            get;
            set;
        }

        public Guid GroupID
        {
            get;
            set;
        }

        public DateTime StartDate { get; set; }

        public DateTime EndDate { get; set; }
        
        protected override bool DoValidate()
        {
            if (FriendID <= 0 && GroupID == Guid.Empty)
            {
                _validationMessage = "No friend or group specified";
                return false;
            }
            
            return true;
        }
    }
}