﻿using Curse.Friends.MicroService;

namespace Curse.Friends.ConversationsWebService.Contracts
{
    public class ConversationMarkReadRequest : BaseRequestContract
    {
        public string MessageID { get; set; }
        public long Timestamp { get; set; }
        public string MachineKey { get; set; }

        protected override bool DoValidate()
        {
            if (Timestamp <= 0)
            {
                _validationMessage = "Timestamp is required";
                return false;
            }         

            if (string.IsNullOrWhiteSpace(MachineKey))
            {
                _validationMessage = "MachineKey is required";
                return false;
            }


            return true; 
        }
    }
}
