﻿using System;
using System.Collections.Generic;
using Curse.Friends.Data.Messaging;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public class AdHocConversation : IConversationContainer, IConversationParent
    {
        private readonly int _userID;
        private readonly Friendship _friendship;

        public AdHocConversation(int userID, Friendship friendship = null)
        {
            ConversationType = ConversationType.AdHoc;
            ConversationID = string.Empty;

            _friendship = friendship;
            _userID = userID;
        }

        #region IConversationContainer

        public string ConversationID { get; private set; }

        public bool CanAccess(int userID)
        {
            throw new NotImplementedException();
        }

        public bool CanView(int userID, out DateTime latestDate, out DateTime earliestDate)
        {
            throw new NotImplementedException();
        }

        public bool CanEditAttachment(int userID, Attachment attachment)
        {
            throw new NotImplementedException();
        }

        public bool CanEditMessage(int userID, ConversationMessage message)
        {
            throw new NotImplementedException();
        }

        public bool CanMention(int userID, ConversationMessage message)
        {
            throw new NotImplementedException();
        }

        public bool CanMentionEveryone(int userID, ConversationMessage message)
        {
            throw new NotImplementedException();
        }

        public bool CanDeleteMessage(int userID, ConversationMessage message)
        {
            throw new NotImplementedException();
        }

        public bool CanSearch(int userID, out DateTime? minSearchDate)
        {
            throw new NotImplementedException();
        }

        public void OnChatMessageChanged(ConversationMessage notification, ConversationNotificationType changeType)
        {
            throw new NotImplementedException();
        }

        void IConversationParent.ToggleHidden(bool isHidden)
        {
            throw new NotImplementedException("Ad hoc chats cannot currently be hidden.");
        }


        void IConversationParent.ToggleMuted(bool isMuted)
        {
            throw new NotImplementedException("Ad hoc chats cannot currently be hidden.");
        }

        bool IConversationContainer.CanHide()
        {
            return false;
        }

        public bool CanLikeMessage(int userID, ConversationMessage message)
        {
            return false;
        }

        public bool CanCall(int userID)
        {
            return true;
        }

        public bool CanUnlockCall(int userID)
        {
            return false;
        }

        public bool CanSendMessage(int userID)
        {
            throw new NotImplementedException();
        }

        public ConversationType ConversationType { get; private set; }

        public void OnChatMessageLike(int userID, string username, ConversationMessage message, Like like)
        {
            throw new NotImplementedException();
        }

        public IConversationParent GetConversationParent(int userID)
        {
            return this;
        }

        public string AvatarUrlSlug
        {
            get { return "users"; }
        }

        public string AvatarUrlID { get { return _friendship == null ? "0" : _friendship.OtherUserID.ToString(); } }

        #endregion

        #region IConversationParent

        DateTime IConversationParent.DateRead
        {
            get { throw new NotImplementedException(); }
            set { throw new NotImplementedException(); }
        }

        int IConversationParent.UnreadCount
        {
            get { throw new NotImplementedException(); }
        }

        void IConversationParent.MarkAsRead(DateTime timestamp)
        {
            throw new NotImplementedException();
        }

        void IConversationParent.MarkAsUnread(DateTime timestamp, int numberMessages)
        {
            throw new NotImplementedException();
        }

        bool IConversationParent.ShouldSendPushNotification(User user, string messageBody, HashSet<int> mentionedUserIDs)
        {
            throw new NotImplementedException();
        }

        public string Title
        {
            get
            {
                if (_friendship == null)
                {
                    return ConversationID;
                }
                else
                {
                    return string.IsNullOrEmpty(_friendship.OtherUserNickname) ? _friendship.OtherUsername : _friendship.OtherUserNickname;
                }
            }
        }

        string IConversationParent.GetSenderName(int senderID, string fallback)
        {
            Friendship friendship;
            if (_friendship != null && _friendship.OtherUserID == senderID)
            {
                friendship = _friendship;
            }
            else
            {
                friendship = Friendship.GetByOtherUserID(_userID, senderID);
            }

            if (friendship == null || friendship.Status != FriendshipStatus.Confirmed)
            {
                return fallback;
            }

            return friendship.FormattedDisplayName;
        }

        #endregion
    }
}