﻿
using Curse.Friends.Enums;

namespace Curse.Friends.Data.DerivedModels
{
    public class ExternalGuildIdentifier
    {
        public AccountType Type { get; set; }
        public int GameRegion { get; set; }
        public string GameServer { get; set; }
        public string Name { get; set; }

        public ExternalGuildIdentifier(AccountType type, int gameRegion, string gameServer, string name)
        {
            Type = type;
            GameRegion = gameRegion;
            GameServer = gameServer;
            Name = name;
        }

        public override bool Equals(object obj)
        {
            return Equals(obj as ExternalGuildIdentifier);
        }

        protected bool Equals(ExternalGuildIdentifier other)
        {
            return other != null &&
                   Type == other.Type &&
                   GameRegion == other.GameRegion &&
                   string.Equals(GameServer, other.GameServer) &&
                   string.Equals(Name, other.Name);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                var hashCode = (int) Type;
                hashCode = (hashCode*397) ^ GameRegion;
                hashCode = (hashCode*397) ^ (GameServer != null ? GameServer.GetHashCode() : 0);
                hashCode = (hashCode*397) ^ (Name != null ? Name.GetHashCode() : 0);
                return hashCode;
            }
        }

        public override string ToString()
        {
            return ExternalGuild.GetGuildIndex(this);
        }
    }
}
