﻿namespace Curse.Friends.Data.DerivedModels
{
    public class FriendshipContext
    {
        public UserRegion MyRegion
        {
            get;
            set;
        }

        public User Me
        {
            get;
            set;
        }

        public UserRegion TheirRegion
        {
            get;
            set;
        }

        public User Them
        {
            get;
            set;
        }

        public FriendshipContext(int myUserID, int theirUserID)
        {
            if (myUserID == theirUserID)
            {
                throw new FriendshipPermissionException("Requesting user cannot interact with theirself.");
            }

            MyRegion = UserRegion.GetLocal(myUserID);

            if (MyRegion == null)
            {
                throw new FriendshipPermissionException("Unable to find requesting user's region: " + myUserID);
            }

            TheirRegion = UserRegion.GetLocal(theirUserID);

            if (TheirRegion == null)
            {
                throw new FriendshipPermissionException("Unable to find target user's region: " + theirUserID);
            }

            Me = User.Get(MyRegion.RegionID, myUserID);

            if (Me == null)
            {
                throw new FriendshipPermissionException("Unable to retrieve requesting user: " + myUserID + " from region: " + MyRegion.RegionID);
            }


            Them = User.Get(TheirRegion.RegionID, theirUserID);

            if (Them == null)
            {
                throw new FriendshipPermissionException("Unable to retrieve other user: " + theirUserID + " from region: " + TheirRegion.RegionID);
            }

        }


        public Friendship GetMyFriendship(bool throwException = false)
        {
            var friendship = Friendship.Get(MyRegion.RegionID, Me.UserID, Them.UserID);
            if (friendship == null && throwException)
            {
                throw new FriendshipPermissionException("Friendship does not exist for user pair: " + Me.UserID + ", " + Them.UserID);
            }
            return friendship;
        }

        public Friendship GetTheirFriendship(bool throwException = false)
        {
            var friendship = Friendship.Get(TheirRegion.RegionID, Them.UserID, Me.UserID);
            if (friendship == null && throwException)
            {
                throw new FriendshipPermissionException("Friendship does not exist for user pair: " + Me.UserID + ", " + Them.UserID);
            }
            return friendship;
        }
    }
}
