﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Curse.Friends.Data.DerivedModels
{
    public class GroupTree
    {

        public static bool IsValidTree(Group root, Dictionary<Guid,IEnumerable<Group>> children)
        {
            return IsValidSubtree(root, ref children, 1) && children.Count == 0;

        }

        private static bool IsValidSubtree(Group root, ref Dictionary<Guid, IEnumerable<Group>> allGroups, int level)
        {
            IEnumerable<Group> immediates;
            if (!allGroups.TryGetValue(root.GroupID, out immediates))
            {
                // No children
                return true;
            }

            if (level > Group.MaxNestingDepth)
            {
                return false;
            }

            allGroups.Remove(root.GroupID);
            var allGroupsRef = allGroups;
            return immediates.All(i => IsValidSubtree(i, ref allGroupsRef, level + 1));
        }
    }
}
