﻿using System.Collections.Generic;
using System.Linq;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.DerivedModels
{    
    public class MutualFriend
    {
        public MutualFriend() { }

        public MutualFriend(int userID)
        {
            UserID = userID;
            MutualUserIDs = new HashSet<int>();            
        }

        public void AddMutualUser(int userID)
        {
            MutualUserIDs.Add(userID);
        }

        public void AddMutualUsers(IEnumerable<int> userIDs)
        {
            foreach(var uid in userIDs)
            {
                AddMutualUser(uid);
            }            
        }


        public int UserID
        {
            get;
            set;
        }

        public HashSet<int> MutualUserIDs
        {
            get;
            set;
        }

        public MutualFriendNotification ToNotification()
        {
            return new MutualFriendNotification
            {
                UserID = UserID,
                MutualUserIDs = MutualUserIDs.ToArray()
            };
        }
    }
}
