﻿using System.Net;
using Curse.Friends.Enums;

namespace Curse.Friends.Data.DerivedModels
{
    public class NewGroupMember
    {
        public static NewGroupMember CurseSystem { get { return new NewGroupMember { UserID = 0, Username = "Curse System" }; } }

        // Default constrcctor to make Json happy
        public NewGroupMember()
        {
            
        }

        public NewGroupMember(int userID)
        {
            UserID = userID;
        }

        public NewGroupMember(int userID, int regionID, string username, string displayName, string ipAddress, GroupRole role)
        {
            UserID = userID;
            Username = username;
            DisplayName = displayName;
            Role = role;
            RegionID = regionID;
            IPAddress = ipAddress;
        }

        public NewGroupMember(UserRegion userRegion, User user, string ipAddress, GroupRole role = null)
        {
            UserID = user.UserID;
            Username = user.Username;
            DisplayName = user.DisplayName;
            RegionID = userRegion.RegionID;
            Role = role;
            IPAddress = ipAddress;
        }

        public NewGroupMember(Friendship friendship, ClientEndpoint mostRecentEndpoint, GroupRole role = null)
        {
            UserID = friendship.OtherUserID;
            Username = friendship.OtherUsername;
            DisplayName = friendship.OtherUserDisplayName;       
            RegionID = friendship.OtherUserRegionID;
            Role = role;
            IPAddress = mostRecentEndpoint != null ? mostRecentEndpoint.IPAddress : null;
        }

        public NewGroupMember(Friendship friendship, GroupRole role = null)
        {
            UserID = friendship.OtherUserID;
            Username = friendship.OtherUsername;
            DisplayName = friendship.OtherUserDisplayName;
            RegionID = friendship.OtherUserRegionID;
            Role = role;
        }

        public int UserID { get; set; }

        public int RegionID { get; set; }

        public string Username { get; set; }

        public string DisplayName { get; set; }

        /// <summary>
        /// The role that this member will enter the group with
        /// </summary>
        public GroupRole Role { get; set; }

        /// <summary>
        /// The group invite code that this member used to entert he group (This is NULL in most cases)
        /// </summary>
        public string InviteCode { get; set; }

        public NotificationPreference? NotificationPreference { get; set; }

        public string IPAddress { get; set; }
    }
}
