﻿using Curse.Friends.Enums;

namespace Curse.Friends.Data.DerivedModels
{
    public class NewGuildInfo
    {
        public NewGuildInfo()
        {
            OtherRoles = new NewGuildRole[0];
            OtherChannels = new NewChannelInfo[0];
            GuildSyncs = new NewGuildSync[0];
            GameIDs = new int[0];
        }

        public string Title { get; set; }

        public GroupSubType Subtype { get; set; }

        public bool IsPublic { get; set; }

        public bool IsSearchable { get; set; }

        public int[] GameIDs { get; set; }

        public NewGuildRole OwnerRole { get; set; }

        public NewGuildRole DefaultRole { get; set; }

        public NewGuildRole[] OtherRoles { get; set; }

        public string DefaultTextChannelName { get; set; }

        public NewChannelInfo[] OtherChannels { get; set; }

        public NewGuildSync[] GuildSyncs { get; set; }
    }

    public class NewChannelInfo
    {
        public string ChannelName { get; set; }

        public GroupMode ChannelMode { get; set; }

        public bool RestrictToOfficers { get; set; }
    }

    public class NewGuildSync
    {
        public AccountType Type { get; set; }

        public int GameID { get; set; }

        public ExternalGuild Guild { get; set; }

        public NewGuildSyncRole[] RolesToCreate { get; set; }
    }

    public class NewGuildSyncRole : NewGuildRole
    {
        public GroupRoleTag Tag { get; set; }
    }
}
