﻿using System;

namespace Curse.Friends.Data
{
    public class DataValidationException : Exception
    {
        public DataValidationException(string message) : base(message)
        {
            
        }

        public DataValidationException(string message, Exception inner) : base(message, inner)
        {
            
        }

        public virtual object ToSerializeableObject()
        {
            return new {Message};
        }
    }

    public class DataValidationException<T> : DataValidationException
    {
        public T ErrorType { get; set; }

        public DataValidationException(string message, T errorType) : base(message)
        {
            ErrorType = errorType;
        }

        public DataValidationException(string message, T errorType, Exception inner) : base(message, inner)
        {
            ErrorType = errorType;
        }

        public override object ToSerializeableObject()
        {
            return new
            {
                Message,
                ErrorType
            };
        }
    }
}
