﻿using System;
using Curse.Extensions;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Messaging
{
    public class ConversationAttachment
    {
        [ElasticProperty(Name = "id", Store = true, Index = FieldIndexOption.No)]
        public string ID
        {
            get;
            set;
        }

        [ElasticProperty(Name = "name", Store = true, Index = FieldIndexOption.No)]
        public string Name
        {
            get;
            set;
        }

        [ElasticProperty(Name = "title", Store = true, Index = FieldIndexOption.No)]
        public string Title
        {
            get;
            set;
        }

        [ElasticProperty(Name = "size", Store = true, Index = FieldIndexOption.No)]
        public long Size
        {
            get;
            set;
        }

        [ElasticProperty(Name = "fileType", Store = true, Index = FieldIndexOption.No)]
        public string FileType
        {
            get;
            set;
        }

        [ElasticProperty(Name = "url", Store = true, Index = FieldIndexOption.No)]
        public string Url
        {
            get;
            set;
        }

        [ElasticProperty(Name = "width", Store = true, Index = FieldIndexOption.No)]
        public int Width
        {
            get;
            set;
        }

        [ElasticProperty(Name = "height", Store = true, Index = FieldIndexOption.No)]
        public int Height
        {
            get;
            set;
        }

        [ElasticProperty(Name = "isAnimated", Store = true, Index = FieldIndexOption.No)]
        public bool IsAnimated
        {
            get;
            set;
        }

        [ElasticProperty(Name = "isEmbed", Store = true, Index = FieldIndexOption.No)]
        public bool IsEmbed
        {
            get;
            set;
        }

        [ElasticProperty(Name = "authorID", Store = true, Index = FieldIndexOption.No)]
        public int AuthorID
        {
            get;
            set;
        }

        [ElasticProperty(Name = "authorName", Store = true, Index = FieldIndexOption.No)]
        public string AuthorName
        {
            get;
            set;
        }

        [ElasticProperty(Name = "timestamp", Store = true, Index = FieldIndexOption.No)]
        public long Timestamp
        {
            get;
            set;
        }

        public static ConversationAttachment FromAttachment(Attachment attachment, string conversationID, string authorName)
        {
            return new ConversationAttachment
            {
                Name = attachment.Filename,
                FileType = attachment.FileType,
                Height = attachment.Height,
                Width = attachment.Width,
                ID = attachment.FileID.ToString(),
                IsAnimated = attachment.IsAnimated,
                IsEmbed = attachment.IsEmbed,
                Size = attachment.FileSize,
                Url = attachment.Url,
                AuthorID = attachment.UploaderUserID,
                AuthorName = authorName,
                Timestamp = attachment.DateUploaded.ToEpochMilliseconds(),
                Title = attachment.Filename ?? attachment.Title
            };
        }

        public AttachmentNotification ToNotification(string conversationID, string messageID)
        {
            return new AttachmentNotification
            {
                Name = Name,
                FileType = FileType,
                Height = Height,
                IsAnimated = IsAnimated,
                IsEmbed = IsEmbed,
                Size = Size,
                ID = ID,
                ConversationID = conversationID,
                MessageID = messageID,
                Url = Url,
                Width = Width,
                Title = Title,
                Timestamp = Timestamp,
                AuthorID = AuthorID,
                AuthorName = AuthorName
            };
        }
    }
}
