﻿using System;

namespace Curse.Friends.Data.Messaging
{
    public static class ConversationConstants
    {
        public static readonly int YearOfInception = 2015;
        public static readonly DateTime DateOfInception = new DateTime(2015, 2, 1, 0, 0, 0, DateTimeKind.Utc);
        public static readonly DateTime DateOfNewBackend = new DateTime(2016, 3, 1, 0, 0, 0, DateTimeKind.Utc);
        
        /// <summary>
        /// The maximum number of characters permitted in a text message.
        /// </summary>
        public const int MaxMessageLength = 10000;

        /// <summary>
        /// The maximum number of characters permitted in a text message.
        /// </summary>
        public const int EditMessageGracePeriodMinutes = 60;

        public static readonly TimeSpan TimestampThrottle = TimeSpan.FromMinutes(1);
        public static readonly TimeSpan TimestampGracePeriod = TimeSpan.FromMinutes(5);
    }
}
