﻿using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Messaging
{
    public class ConversationMessageEmoteSubstitution
    {
        [ElasticProperty(Name="messageText", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string MessageText { get; set; }

        [ElasticProperty(Name = "emoteId", Type = FieldType.Long, Index = FieldIndexOption.No)]
        public long EmoteID { get; set; }

        [ElasticProperty(Name="emoteSet", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int EmoteSet { get; set; }

        [ElasticProperty(Name = "startIndex", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int StartIndex { get; set; }

        [ElasticProperty(Name = "endIndex", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int EndIndex { get; set; }

        [ElasticProperty(Name = "emoteHeight", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int EmoteHeight { get; set; }

        [ElasticProperty(Name = "emoteWidth", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int EmoteWidth { get; set; }

        public ConversationMessageEmoteSubstitutionNotification ToNotification()
        {
            return new ConversationMessageEmoteSubstitutionNotification
            {
                MessageText = MessageText,
                EmoteID = EmoteID,
                EmoteSet = EmoteSet,
                StartIndex = StartIndex,
                EndIndex = EndIndex,
                EmoteHeight = EmoteHeight,
                EmoteWidth = EmoteWidth,
            };
        }
    }
}
