﻿using System;
using System.Web.UI.WebControls;
using Curse.Aerospike;
using Curse.Friends.Data.Models;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public enum AttachmentStatus
    {
        Available,
        Deleted
    }

    [TableDefinition(TableName = "Attachment", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class Attachment : BaseTable<Attachment>
    {
        public const int MaxFileSize = 52428800; // 50 MB
        public const int MaxTitleLength = 64;

        [Column("FileID", KeyOrdinal = 1)]
        public Guid FileID { get; set; }

        [Column("Conversation", IsIndexed = true)]
        public string ConversationID { get; set; }

        [Column("UserID", IsIndexed = true)]
        public int UploaderUserID { get; set; }

        [Column("Url")]
        public string Url { get; set; }

        [Column("Filename")]
        public string Filename { get; set; }

        [Column("Title")]
        public string Title { get; set; }

        [Column("FileType")]
        public string FileType { get; set; }

        [Column("FileSize")]
        public int FileSize { get; set; }

        [Column("DateUploaded")]
        public DateTime DateUploaded { get; set; }

        [Column("Status")]
        public AttachmentStatus Status { get; set; }

        [Column("StorageRegion")]
        public int StorageRegionID { get; set; }

        [Column("IsEmbed")]
        public bool IsEmbed { get; set; }

        #region Embed Only Properties

        [Column("IsAnimated")]
        public bool IsAnimated { get; set; }

        [Column("Width")]
        public int Width { get; set; }

        [Column("Height")]
        public int Height { get; set; }

        #endregion

        public AttachmentNotification ToNotification()
        {
            return new AttachmentNotification
            {
                ID = FileID.ToString(),
                Url = Url,
                Name = Filename,
                FileType = FileType,
                Height = Height,
                IsAnimated = IsAnimated,
                IsEmbed = IsEmbed,
                Size = FileSize,
                Width = Width,
                Title = Title ?? Filename,
                RegionID = StorageRegionID
            };
        }

        public string GetAuthorName()
        {
            var userRegion = UserRegion.GetLocal(UploaderUserID);
            var user = userRegion?.GetUser();
            return user?.GetTitleName();
        }

        public bool IsImage
        {
            get { return FileType != null && FileType.StartsWith("image", StringComparison.OrdinalIgnoreCase); }
        }
    }
}
