﻿using Curse.Aerospike;
using Curse.Friends.Enums;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Configuration;
using Curse.Extensions;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "Avatar", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class Avatar : BaseTable<Avatar>
    {
        [Column("AvatarType", KeyOrdinal = 1)]
        public int AvatarType
        {
            get;
            set;
        }

        [Column("EntityID", KeyOrdinal = 2)]
        public string EntityID
        {
            get;
            set;
        }

        [Column("Url")]
        public string Url
        {
            get;
            set;
        }

        [Column("FileRegionID")]
        public int FileRegionID
        {
            get;
            set;
        }

        [Column("StorageKey")]
        public string StorageKey
        {
            get;
            set;
        }

        [Column("Filename")]
        public string Filename
        {
            get;
            set;
        }

        [Column("Timestamp")]
        public long Timestamp
        {
            get;
            set;
        }

        [Column("Inappropriate")]
        public bool IsInappropriate
        {
            get; 
            set;
        }

        [Column("Migrated")]
        public bool IsMigrated { get; set; }

        public static Avatar GetByTypeAndID(AvatarType type, string id)
        {
            return GetLocal((int)type, id);
        }

        public static Avatar CreateOrUpdate(AvatarType type, string id, string url)
        {
            var avatar = GetByTypeAndID(type, id);
            if (avatar == null)
            {
                avatar = new Avatar
                {
                    AvatarType = (int)type,
                    EntityID = id,
                    Timestamp = DateTime.UtcNow.ToEpochMilliseconds(),
                    Url = url,
                };
                avatar.InsertLocal();
            }
            else if (avatar.Url != url)
            {
                avatar.Url = url;
                avatar.Timestamp = DateTime.UtcNow.ToEpochMilliseconds();
                avatar.Update(a => a.Url, a => a.Timestamp);
            }
            return avatar;
        }

        public static string GetUserAvatarUrl(int userID)
        {
            return string.Format(FriendsServiceConfiguration.Instance.AvatarUrlFormat, "users", userID);
        }
    }
}
