﻿using System;
using Curse.Aerospike;

namespace Curse.Friends.Data.Models
{    
    [TableDefinition(TableName = "Bot", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class Bot : BaseTable<Bot>
    {
        [Column("UserID", KeyOrdinal = 1)]
        public int UserID { get; set; }

        [Column("IsVerified", IsIndexed = true)]
        public bool IsVerified { get; set; }

        [Column("DateCreated")]
        public DateTime DateCreated { get; set; }

        [Column("DateModified")]
        public DateTime DateModified { get; set; }

        public static Bot GetByUserID(int userID)
        {
            return GetLocal(userID);
        }
    }
}
