﻿using System;
using Aerospike.Client;
using Curse.Aerospike;
using Curse.Extensions;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "ExternalAccountMapping", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class ExternalAccountMapping : BaseTable<ExternalAccountMapping>
    {
        [Column("UserID", KeyOrdinal = 1, IsIndexed = true)]
        public int UserID { get; set; }

        [Column("AccountType",KeyOrdinal = 2)]
        public AccountType Type { get; set; }

        [Column("ExternalID", KeyOrdinal = 3, IsIndexed = true)]
        public string ExternalID { get; set; }

        [Column("ExternalName")]
        public string ExternalName { get; set; }

        [Column("IsDeleted")]
        public bool IsDeleted { get; set; }

        [Obsolete]
        [Column("RegionID")]
        public int RegionID { get; set; }

        [Column("DateMapped")]
        public DateTime DateMapped { get; set; }

        [Column("MemberSyncTime")]
        public DateTime LastMembershipSyncTime { get; set; }


        protected override void Validate()
        {
            if (RegionID <= 0)
            {
                throw new Exception("Region ID cannot be 0");
            }

            if (UserID <= 0)
            {
                throw new Exception("UserID cannot be 0");
            }

            if (string.IsNullOrWhiteSpace(ExternalID))
            {
                throw new Exception("External ID cannot be null or whitespace");
            }
        }

        public ExternalAccountContract ToNotification(ExternalAccount account)
        {
            return new ExternalAccountContract
            {
                ExternalID = ExternalID,
                ExternalName = account.ExternalUsername,
                ExternalDisplayName = account.ExternalDisplayName,
                Type = Type,
                DateLinked = DateMapped.SafeToEpochMilliseconds(),
                IsPartnered = account.IsPartnered
            };
        }

        public object GetKeyHashes()
        {
            return new
            {
                RetrievedKey = Key != null ? Convert.ToBase64String(Key.digest) : null,
                GeneratedKeyHash = Convert.ToBase64String(new Key(GetKeySpace(GetRegionKey(LocalConfigID)), "ExternalAccountMapping", GetGeneratedKey()).digest)
            };
        }
    }
}
