﻿using System.Collections.Generic;
using System.Linq;
using Curse.Aerospike;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "ExternalCommunityEmoticon", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class ExternalCommunityEmoticon : BaseTable<ExternalCommunityEmoticon>
    {
        [Column("CommunityType", KeyOrdinal = 1)]
        public AccountType CommunityType { get; set; }

        [Column("SyncID", KeyOrdinal = 2, IsIndexed = true)]
        public string SyncID { get; set; }

        [Column("Regex", KeyOrdinal = 3)]
        public string Regex { get; set; }

        [Column("RequiredRoles")]
        public HashSet<int> RequiredRoles { get; set; }

        [Column("Url")]
        public string Url { get; set; }

        [Column("IsDeleted")]
        public bool IsDeleted { get; set; }

        public static ExternalCommunityEmoticon[] GetAllByTypeAndSyncID(AccountType communityType, string syncID)
        {
            var emoticons = new List<ExternalCommunityEmoticon>();
            emoticons.AddRange(GetAllLocal(e => e.SyncID, syncID).Where(e => e.CommunityType == communityType));
            return emoticons.ToArray();
        }

        public ExternalCommunityEmoticonContract ToNotification()
        {
            return new ExternalCommunityEmoticonContract
            {
                CommunityType = CommunityType,
                SyncID = SyncID,
                Regex = Regex,
                RequiredRoles = new HashSet<GroupRoleTag>(RequiredRoles.Select(r => (GroupRoleTag) r))
            };
        }

        public string GetAvatarEntityID()
        {
            return GetAvatarEntityID(CommunityType, SyncID, Regex);
        }

        public static string GetAvatarEntityID(AccountType type, string syncID, string regex)
        {
            return string.Format("{0}/{1}/{2}", type, syncID, regex);
        }
    }
}
