﻿using System;
using Curse.Aerospike;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public enum ExternalCommunityMembershipStatus
    {
        Active,
        GracePeriod,
        Deleted
    }

    [TableDefinition(TableName = "ExternalCommunityMembership", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class ExternalCommunityMembership : BaseTable<ExternalCommunityMembership>
    {
        [Column("ExtUserID", KeyOrdinal = 1, IsIndexed = true)]
        public string ExternalUserID { get; set; }

        [Column("ExtCommID", KeyOrdinal = 2, IsIndexed = true)]
        public string ExternalCommunityID { get; set; }

        [Column("Type", KeyOrdinal = 3)]
        public AccountType Type { get; set; }

        //[Column("Role", KeyOrdinal = 4)]
        //public string Role { get; set; }

        [Column("RoleTag", KeyOrdinal = 4)]
        public GroupRoleTag RoleTag { get; set; }

        [Column("CommAndTypeIdx", IsIndexed = true)]
        public string CommunityAndTypeIndex { get; set; }

        [Column("UserAndTypeIdx", IsIndexed = true)]
        public string UserAndTypeIndex { get; set; }

        [Column("UsrTypeRoleIdx", IsIndexed = true)]
        public string UserTypeAndRoleIndex { get; set; }

        [Column("ComTypeRoleIdx", IsIndexed = true)]
        public string CommunityTypeAndRoleIndex { get; set; }

        [Column("ExtUsername")]
        public string ExternalUsername { get; set; }

        [Column("ExtDisplayName")]
        public string ExternalUserDisplayName { get; set; }

        [Column("FirstRoleDate")]
        public DateTime FirstRoleDate { get; set; }

        [Column("LastRoleDate")]
        public DateTime CurrentRoleDate { get; set; }

        [Column("Status")]
        public ExternalCommunityMembershipStatus Status { get; set; }

        [Column("StatusDate")]
        public DateTime StatusDate { get; set; }

        [Column("ExtCommName")]
        public string ExternalCommunityName { get; set; }

        [Column("ExtCommDisp")]
        public string ExternalCommunityDisplayName { get; set; }

        [Column("EntryNumber")]
        public int EntryNumber { get; set; }

        protected override void OnBeforeInsertOrUpdate()
        {
            FirstRoleDate = FirstRoleDate.ToUniversalTime();
            CurrentRoleDate = CurrentRoleDate.ToUniversalTime();
        }

        public static ExternalCommunityMembership[] GetAllByExternalCommunityIDAndType(AerospikeConfiguration config, string externalCommunityID, AccountType type)
        {
            return GetAll(config, p => p.CommunityAndTypeIndex, externalCommunityID + type);
        }
    }
}
