﻿using System;
using Curse.Aerospike;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "ExternalCommunityMembershipMapping", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class ExternalCommunityMembershipMapping : BaseTable<ExternalCommunityMembershipMapping>
    {
        [Column("ExtUserID", KeyOrdinal = 1, IsIndexed = true)]
        public string ExternalUserID { get; set; }

        [Column("ExtCommID", KeyOrdinal = 2, IsIndexed = true)]
        public string ExternalCommunityID { get; set; }

        [Column("Type", KeyOrdinal = 3)]
        public AccountType Type { get; set; }

        [Column("Role")]
        public string Role { get; set; }

        [Column("RoleTag", KeyOrdinal = 4, IsIndexed = true)]
        public GroupRoleTag RoleTag { get; set; }

        [Column("GroupID", KeyOrdinal = 5)]
        public Guid GroupID { get; set; }

        [Column("Status")]
        public ExternalCommunityMembershipStatus Status { get; set; }

        [Column("StatusDate")]
        public DateTime StatusDate { get; set; }

        [Column("CommAndTypeIdx", IsIndexed = true)]
        public string CommunityAndTypeIndex { get; set; }

        [Column("UserAndTypeIdx", IsIndexed = true)]
        public string UserAndTypeIndex { get; set; }

        [Column("UsrTypeComIdx")]
        public string UserTypeAndCommunityIndex { get; set; }

        [Column("ExtUsername")]
        public string ExternalUsername { get; set; }

        [Column("ComTypeGrpIdx")]
        public string CommunityTypeAndGroupIndex { get; set; }
    }
}
