﻿using System;
using Curse.Aerospike;
using Curse.Friends.Data.DerivedModels;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "ExternalGuildMapping", ReplicationMode = ReplicationMode.Mesh, KeySpace = "CurseVoice-Global")]
    public class ExternalGuildMapping : BaseTable<ExternalGuildMapping>
    {
        [Column("Source", KeyOrdinal = 1)]
        public AccountType Type { get; set; }

        [Column("Region", KeyOrdinal = 2)]
        public int GameRegion { get; set; }

        [Column("Server", KeyOrdinal = 3)]
        public string GameServer { get; set; }

        [Column("Name", KeyOrdinal = 4)]
        public string Name { get; set; }

        [Column("GroupID", KeyOrdinal = 5, IsIndexed = true)]
        public Guid GroupID { get; set; }

        [Column("IsDeleted")]
        public bool IsDeleted { get; set; }

        public string GetGuildIndex()
        {
            return ExternalGuild.GetGuildIndex(Type, GameRegion, GameServer, Name);
        }

        public ExternalGuildIdentifier GetGuildInfo()
        {
            return ExternalGuild.GetGuildInfo(Type, GameRegion, GameServer, Name);
        }
    }
}
