﻿using System;
using System.Collections.Generic;
using Curse.Aerospike;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "ExternalGuildRole", ReplicationMode = ReplicationMode.Mesh, KeySpace = "CurseVoice-Global")]
    public class ExternalGuildRole : BaseTable<ExternalGuildRole>
    {
        [Column("Source", KeyOrdinal = 1)]
        public AccountType Type { get; set; }

        [Column("GuildRegion", KeyOrdinal = 2)]
        public int GuildGameRegion { get; set; }

        [Column("GuildServer", KeyOrdinal = 3)]
        public string GuildGameServer { get; set; }

        [Column("GuildName", KeyOrdinal = 4)]
        public string GuildName { get; set; }

        [Column("RoleTag", KeyOrdinal = 5)]
        public GroupRoleTag RoleTag { get; set; }

        [Column("GuildIdx", IsIndexed = true)]
        public string GuildIndex { get; set; }

        public static string GetDefaultRoleName(AccountType type, GroupRoleTag tag)
        {
            switch (type)
            {
                case AccountType.WorldOfWarcraft:
                    return GetWorldOfWarcraftRoleName(tag);
                default:
                    throw new InvalidOperationException("Unsupported guild type: " + type);
            }
        }

        private static string GetWorldOfWarcraftRoleName(GroupRoleTag tag)
        {
            switch (tag)
            {
                case GroupRoleTag.GuildMasterRank:
                    return "Guild Master";
                case GroupRoleTag.GuildRank1:
                    return "Rank 1";
                case GroupRoleTag.GuildRank2:
                    return "Rank 2";
                case GroupRoleTag.GuildRank3:
                    return "Rank 3";
                case GroupRoleTag.GuildRank4:
                    return "Rank 4";
                case GroupRoleTag.GuildRank5:
                    return "Rank 5";
                case GroupRoleTag.GuildRank6:
                    return "Rank 6";
                case GroupRoleTag.GuildRank7:
                    return "Rank 7";
                case GroupRoleTag.GuildRank8:
                    return "Rank 8";
                case GroupRoleTag.GuildRank9:
                    return "Rank 9";
                default:
                    throw new InvalidOperationException("Unsupported role tag for Battle Net Role: " + tag);
            }
        }

        private static readonly GroupRoleTag[] _wowTags =
        {
            GroupRoleTag.GuildMasterRank, GroupRoleTag.GuildRank1, GroupRoleTag.GuildRank2, GroupRoleTag.GuildRank3, GroupRoleTag.GuildRank4, GroupRoleTag.GuildRank5, GroupRoleTag.GuildRank6,
            GroupRoleTag.GuildRank7, GroupRoleTag.GuildRank8, GroupRoleTag.GuildRank9
        };

        public static IReadOnlyList<GroupRoleTag> GetRoleTags(AccountType type)
        {
            return _wowTags;
        }
    }
}
