﻿using System;
using System.Linq;
using Curse.Aerospike;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "GroupBannedUser", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class GroupBannedUser : BaseTable<GroupBannedUser>
    {
        public static readonly int BanReasonMaxLength = 1024;

        [Column("GroupID", KeyOrdinal = 1, IsIndexed = true)]
        public Guid GroupID { get; set; }

        [Column("UserID", KeyOrdinal = 2)]
        public int UserID { get; set; }

        [Column("Username")]
        public string Username { get; set; }

        [Column("RequestorID")]
        public int RequestorID { get; set; }

        [Column("RequestorName")]
        public string RequestorUsername { get; set; }

        [Column("StatusDate")]
        public DateTime DateStatusChanged { get; set; }

        [Column("IsDeleted")]
        public bool IsDeleted { get; set; }

        [Column("Reason")]
        public string Reason { get; set; }

        [Column("IPAddress")]
        public string IPAddress { get; set; }

        public static bool IsBanned(Guid groupID, int userID, string ipAddress)
        {
            var bans = GetAllLocal(g => g.GroupID, groupID);
            return IsBanned(userID, ipAddress, bans);
        }

        public static bool IsBanned(int userID, string ipAddress, GroupBannedUser[] bans)
        {
            // No IP supplied, so just check the user ID
            if (string.IsNullOrWhiteSpace(ipAddress))
            {
                return bans.Any(b => !b.IsDeleted && b.UserID == userID);
            }

            // IP supplied, so check for an IP ban
            return bans.Any(b => !b.IsDeleted && (b.UserID == userID || b.IPAddress == ipAddress));
        }
    }
}
