﻿using System;
using System.Collections.Generic;
using Curse.Aerospike;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public enum EmoticonStatus
    {
        Unknown,
        Active,
        Deleted,
        Conflict
    }

    [TableDefinition(TableName = "GroupEmoticon", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class GroupEmoticon : BaseTable<GroupEmoticon>
    {
        [Column("GroupID", KeyOrdinal = 1, IsIndexed = true)]
        public Guid GroupID { get; set; }

        [Column("Regex", KeyOrdinal = 2)]
        public string RegexString { get; set; }

        [Column("Source", KeyOrdinal = 3)]
        public EmoticonSource Source { get; set; }

        [Column("SyncID")]
        public string SyncID { get; set; }

        [Column("Url")]
        public string Url { get; set; }

        [Column("Status")]
        public EmoticonStatus Status { get; set; }

        [Column("RequiredRoles")]
        public HashSet<int> RequiredRoles { get; set; }

        public GroupEmoticonNotification ToNotification()
        {
            return new GroupEmoticonNotification
            {
                GroupID = GroupID,
                RegexString = RegexString,
                RequiredRoles = RequiredRoles,
                SyncID = SyncID,
                Url = Url
            };
        }
    }
}
