﻿using System;
using Curse.Aerospike;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public enum GroupGiveawayParticipantStatus
    {
        Entered,
        OptedOut,
        Winner,
        Claimed,
        Ineligible
    }

    [TableDefinition(TableName = "GroupGiveawayParticipant", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class GroupGiveawayParticipant : BaseTable<GroupGiveawayParticipant>
    {
        [Column("UserID", KeyOrdinal = 1, IsIndexed = true)]
        public int UserID { get; set; }

        [Column("GroupID", KeyOrdinal = 2)]
        public Guid GroupID { get; set; }

        [Column("GiveawayID", KeyOrdinal = 3)]
        public int GiveawayID { get; set; }

        [Column("GroupAndIDIdx", IsIndexed = true)]
        public string GroupAndGiveawayIdIndex { get; set; }

        [Column("DateEntered")]
        public DateTime DateEntered { get; set; }

        [Column("StatusDate")]
        public DateTime DateStatusChanged { get; set; }

        [Column("Status")]
        public GroupGiveawayParticipantStatus Status { get; set; }

        [Column("ReferrerUserID")]
        public int ReferrerUserID { get; set; }

        [Column("Username")]
        public string Username { get; set; }
    }
}
