﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Aerospike;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "GroupGiveawaySettings", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.HomeRegion)]
    public class GroupGiveawaySettings : BaseTable<GroupGiveawaySettings>, IModelRegion
    {
        [Column("GroupID", KeyOrdinal = 1)]
        public Guid GroupID { get; set; }

        [Column("RequiredRoles")]
        public HashSet<int> RequiredRoles { get; set; }

        [Column("RoleBonuses")]
        public Dictionary<int, int> RoleBonuses { get; set; }

        [Column("ResponseWindow")]
        public TimeSpan ResponseWindow { get; set; }

        [Column("SharingBonus")]
        public int SharingBonus { get; set; }

        [Column("RegionID")]
        public int RegionID { get; set; }

        [Column("IgnoredUsers")]
        public HashSet<int> IgnoredUsers { get; set; }

        [Column("AutoEnterActiv")]
        public bool AutoEnterActiveUsers { get; set; }

        [Column("AutoEnterRoles")]
        public HashSet<int> AutoEnterRoles { get; set; }

        [Column("AutoClaimRoles")]
        public HashSet<int> AutoClaimRoles { get; set; }

        [Column("RollsPreWinner")]
        public int RollsBeforeWinner { get; set; }

        [Column("AllowRepeatWin")]
        public bool AllowRepeatWinners { get; set; }

        [Column("IncludeOffline")]
        public bool IncludeOfflineMembers { get; set; }

        public GroupGiveawaySettingsNotification ToNotification()
        {
            return new GroupGiveawaySettingsNotification
            {
                RequiredRoles = RequiredRoles,
                GroupID = GroupID,
                ResponseWindowSeconds = (int)ResponseWindow.TotalSeconds,
                AllowRepeatWinners = AllowRepeatWinners,
                AutoClaimRoles = AutoClaimRoles,
                AutoEnterActiveUsers = AutoEnterActiveUsers,
                AutoEnterRoles = AutoEnterRoles,
                IgnoredMembers = GroupMember.MultiGetLocal(IgnoredUsers.Select(id => new KeyInfo(GroupID, id))).Where(m => !m.IsDeleted).Select(m=>m.ToNotification(null)).ToArray(),
                RoleBonuses = RoleBonuses,
                RollsBeforeWinner = RollsBeforeWinner,
                SharingBonus = SharingBonus,
                IncludeOfflineMembers = IncludeOfflineMembers,
            };
        }
    }
}
