﻿using System;
using System.Collections.Generic;
using Curse.Aerospike;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "GroupPollParticipant", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class GroupPollParticipant : BaseTable<GroupPollParticipant>
    {
        [Column("ParticipantID", KeyOrdinal = 1)]
        public string ParticipantID { get; set; }

        [Column("GroupID", KeyOrdinal = 2)]
        public Guid GroupID { get; set; }

        [Column("PollID", KeyOrdinal = 3)]
        public int PollID { get; set; }

        [Column("DateVoted")]
        public DateTime DateVoted { get; set; }

        [Column("Vote")]
        public HashSet<int> Vote { get; set; } 

        [Column("LookupIndex", IsIndexed = true)]
        public string LookupIndex { get; set; }

        #region Legacy

        [Column("UserID")]
        public int UserID { get; set; }

        #endregion
    }
}
